(define (partition s)
  (define n (string-length s))
  (define res '())
  (define (is-palindrome? l r)
    (let loop ([l l] [r r])
      (if (>= l r)
          #t
          (and (char=? (string-ref s l) (string-ref s r))
               (loop (add1 l) (sub1 r)))))
  (define (backtrack start path)
    (if (>= start n)
        (set! res (cons (reverse path) res))
        (for ([end (in-range start n)])
          (when (is-palindrome? start end)
            (backtrack (add1 end) (cons (substring s start (add1 end)) path))))))
  (backtrack 0 '())
  (reverse res))